# Release Checklist

## Pre-Release

### Code Quality
- [ ] All PRs merged and reviewed
- [ ] No critical bugs in backlog
- [ ] Test coverage meets threshold (>80%)
- [ ] All tests passing
- [ ] No TypeScript errors
- [ ] Linting passes

### Documentation
- [ ] Changelog updated
- [ ] Migration guide written (if breaking changes)
- [ ] Storybook stories updated
- [ ] API documentation current
- [ ] README updated if needed

### Accessibility
- [ ] a11y audit complete
- [ ] No new accessibility regressions
- [ ] Keyboard navigation tested
- [ ] Screen reader tested

### Design
- [ ] Figma components updated
- [ ] Design tokens synced
- [ ] Visual QA complete
- [ ] Design review sign-off

### Communication
- [ ] Release notes drafted
- [ ] Breaking changes documented
- [ ] Stakeholders notified
- [ ] Support channels prepared

---

## Release Day

### Deployment
- [ ] Version number bumped
- [ ] Changelog finalized
- [ ] Package published
- [ ] Figma library published
- [ ] Documentation deployed

### Announcement
- [ ] Release notes published
- [ ] Slack/Teams announcement sent
- [ ] Email sent to subscribers
- [ ] Support team briefed

---

## Post-Release

### Monitoring
- [ ] Check for installation issues
- [ ] Monitor support channels
- [ ] Track adoption metrics
- [ ] Collect feedback

### Follow-up (within 1 week)
- [ ] Address critical feedback
- [ ] Plan patch release if needed
- [ ] Retrospective scheduled
- [ ] Lessons learned documented

---

## Release Notes Template

### [Version X.Y.Z] - [Date]

#### 🚀 New Features
- Feature description

#### 🐛 Bug Fixes
- Fix description

#### 💥 Breaking Changes
- Breaking change description
- Migration: [link to migration guide]

#### 🔧 Improvements
- Improvement description

#### 📚 Documentation
- Documentation update description

#### 🙏 Contributors
- @username for [contribution]

---
Generated from petrilahdelma.com/toolbox/governance-pack
© 2026 Petri Lahdelma
