# Deprecation Policy

## Overview
This policy defines how we deprecate and remove features from the design system.

## Deprecation Timeline

### Phase 1: Announcement (Release N)
- Feature marked as deprecated in documentation
- Console warnings added to deprecated components
- Migration guide published
- Announcement in release notes

### Phase 2: Warning Period (Release N+1 to N+2)
- Continued warnings in console
- Deprecated components still functional
- Active support for migration questions
- Usage metrics tracked

### Phase 3: Removal (Release N+3)
- Feature removed from package
- Breaking change documented
- Final migration support

**Minimum deprecation period: 3 minor releases or 6 months, whichever is longer**

## Deprecation Notice Format

```typescript
/**
 * @deprecated Since version 2.0.0. Use NewComponent instead.
 * Will be removed in version 3.0.0.
 * Migration guide: https://docs.example.com/migration/old-to-new
 */
```

## Console Warning Format

```
[DesignSystem] Warning: OldComponent is deprecated and will be removed in v3.0.0.
Please migrate to NewComponent. See migration guide: https://...
```

## Exceptions
Emergency security fixes may bypass the standard timeline with:
- Clear communication to all consumers
- Immediate migration support
- Extended office hours for questions

---
Generated from petrilahdelma.com/toolbox/governance-pack
© 2026 Petri Lahdelma
