# RFC Template: [Component/Feature Name]

## Metadata
- **RFC Number**: RFC-XXXX
- **Author**: [Name]
- **Status**: Draft | In Review | Approved | Rejected | Superseded
- **Created**: [Date]
- **Updated**: [Date]

---

## Summary
A brief, one-paragraph explanation of the proposal.

## Motivation
Why are we doing this? What problem does it solve? What use cases does it support?

## Detailed Design

### API / Props
```typescript
interface ComponentProps {
  // Define the component API
  variant?: 'primary' | 'secondary' | 'ghost';
  size?: 'sm' | 'md' | 'lg';
  disabled?: boolean;
  // ...
}
```

### States
- Default
- Hover
- Focus
- Active
- Disabled
- Loading (if applicable)

### Accessibility
- Keyboard navigation
- Screen reader support
- ARIA attributes
- Focus management

### Theming
- Token dependencies
- Dark mode considerations

## Alternatives Considered
What other approaches were considered and why were they rejected?

## Migration Strategy
If this is a breaking change, how do teams migrate?

## Timeline
- Design: [X weeks]
- Implementation: [X weeks]
- Documentation: [X weeks]
- Review & QA: [X weeks]

## Open Questions
List any unresolved questions or decisions.

---

## Approval
- [ ] Design review complete
- [ ] Engineering review complete
- [ ] Accessibility review complete
- [ ] Documentation review complete

---
Generated from petrilahdelma.com/toolbox/governance-pack
© 2026 Petri Lahdelma
