# RACI Template for Design System Governance

## Overview
This RACI matrix defines ownership and decision rights for your design system.

R = Responsible (does the work)
A = Accountable (final decision maker)
C = Consulted (provides input)
I = Informed (kept in the loop)

## Component Lifecycle

| Activity | DS Team | Engineering | Design | Product |
|----------|---------|-------------|--------|---------|
| Component proposal | R | C | C | I |
| Technical design | C | R | C | I |
| Visual design | C | I | R | I |
| Implementation | I | R | C | I |
| Documentation | R | C | C | I |
| Code review | I | R | I | I |
| Design review | R | I | A | I |
| Release decision | A | C | C | I |

## Token Management

| Activity | DS Team | Engineering | Design | Product |
|----------|---------|-------------|--------|---------|
| Token proposal | R | C | C | I |
| Naming conventions | A | C | C | I |
| Value changes | R | C | A | I |
| Breaking changes | A | R | C | C |
| Deprecation | A | C | C | I |

## Governance

| Activity | DS Team | Engineering | Design | Product |
|----------|---------|-------------|--------|---------|
| RFC review | A | C | C | I |
| Release planning | R | C | C | I |
| Breaking change approval | A | C | C | C |
| Contribution guidelines | A | C | C | I |

---
Generated from petrilahdelma.com/toolbox/governance-pack
© 2026 Petri Lahdelma
